<?php
require '/home/shakuniya/billapi.shakuniya.in/vendor/autoload.php';

use Jose\Component\KeyManagement\JWKFactory;
use Jose\Component\Core\AlgorithmManager;
use Jose\Component\Encryption\Algorithm\KeyEncryption\A256KW;
use Jose\Component\Encryption\Algorithm\ContentEncryption\A256CBCHS512;
use Jose\Component\Encryption\Compression\Deflate;
use Jose\Component\Encryption\Compression\CompressionMethodManager;
use Jose\Component\Encryption\JWEBuilder;
use Jose\Component\Encryption\JWEDecrypter;
use Jose\Component\Encryption\Serializer\CompactSerializer;

// === CONFIG ===
const CLIENT_ID        = 'bduat2k526';
const SHARED_SECRET    = 'apLkPDnO9NYf';  // base64url‑encoded
const MERC_ID          = 'BDUAT2K526';
const CREATE_ORDER_URL = 'https://uat1.billdesk.com/u2/payments/ve1_2/orders/create';

// === BUILD JWK FROM SECRET ===
$secretRaw = base64_decode(strtr(SHARED_SECRET, '-_', '+/'));
$jwk = JWKFactory::createFromSecret(
    $secretRaw,
    [
        'alg' => 'A256KW',
        'use' => 'enc',
    ]
);

// === SETUP JOSE COMPONENTS ===
$algManager  = new AlgorithmManager([ new A256KW() ]);
$encManager  = new AlgorithmManager([ new A256CBCHS512() ]);
$compManager = new CompressionMethodManager([ new Deflate() ]);

$jweBuilder   = new JWEBuilder($algManager, $encManager, $compManager);
$jweDecrypter = new JWEDecrypter($algManager, $encManager, $compManager);
$serializer   = new CompactSerializer();

// === 1) BUILD YOUR ORDER PAYLOAD ===
$payload = json_encode([
    'mercid'     => MERC_ID,
    'orderid'    => 'ORD' . time(),
    'amount'     => '100.00',
    'order_date' => date('Y-m-d\TH:i:sP'),
    'currency'   => '356',
    'ru'         => 'https://your-site.com/return',
    'itemcode'   => 'DIRECT',
    'device'     => [
        'init_channel'             => 'internet',
        'ip'                       => $_SERVER['REMOTE_ADDR'] ?? '',
        'user_agent'               => $_SERVER['HTTP_USER_AGENT'] ?? '',
        'accept_header'            => $_SERVER['HTTP_ACCEPT'] ?? '',
        'browser_tz'               => (new DateTime())->getOffset() / 60,
        'browser_color_depth'      => '24',
        'browser_java_enabled'     => 'false',
        'browser_screen_height'    => '',
        'browser_screen_width'     => '',
        'browser_language'         => $_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? '',
        'browser_javascript_enabled'=> 'true',
    ],
]);

// === 2) ENCRYPT TO JWE ===
$jwe = $jweBuilder
    ->create()
    ->withPayload($payload)
    ->withSharedProtectedHeader([
        'alg'      => 'A256KW',
        'enc'      => 'A256CBC-HS512',   // <-- fixed header name
        'clientid' => CLIENT_ID
    ])
    ->addRecipient($jwk)
    ->build();

$encryptedRequest = $serializer->serialize($jwe, 0);
echo "encrypted request: $encryptedRequest";
// === 3) SEND CREATE ORDER REQUEST ===
$ch = curl_init(CREATE_ORDER_URL);
$traceid   = bin2hex(random_bytes(16));
$timestamp = time();
curl_setopt_array($ch, [
    CURLOPT_POST           => true,
    CURLOPT_POSTFIELDS     => $encryptedRequest,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER     => [
        'Content-Type: application/jose',
        'Accept: application/jose',
        "BD-Traceid: $traceid",
        "BD-Timestamp: $timestamp"
    ],
]);
$encryptedResponse = curl_exec($ch);
if (curl_errno($ch)) {
    die('cURL Error: ' . curl_error($ch));
}
curl_close($ch);
echo "response: ".$encryptedResponse;
// unserialize into a JWS object
$loadedJws = $serializer->unserialize($encryptedResponse);

// verify signature
if (! $jwsVerifier->verifyWithKey($loadedJws, $jwk, 0)) {
    die('Signature verification failed');
}

// extract payload JSON
$responseJson = $loadedJws->getPayload();
$responseData = json_decode($responseJson, true);
echo "</br>sss";

// === 5) EXTRACT REDIRECT LINK & AUTO‑SUBMIT ===
$redirectLink = null;
foreach ($responseData['links'] as $link) {
    if (($link['rel'] ?? '') === 'redirect') {
        $redirectLink = $link;
        break;
    }
}
echo $redirectLink;
if (! $redirectLink) {
    die('No redirect link found in response');
}

?>
<!DOCTYPE html>
<html>
<head><meta charset="utf-8"><title>Redirecting to Payment</title></head>
<body>
  <form id="bd_form" action="<?= htmlspecialchars($redirectLink['href'])?>" method="POST">
    <?php foreach ($redirectLink['parameters'] as $k => $v): ?>
      <input type="hidden" name="<?= htmlspecialchars($k)?>" value="<?= htmlspecialchars($v)?>">
    <?php endforeach; ?>
  </form>
  <script>document.getElementById('bd_form').submit();</script>
  <p>Redirecting you to BillDesk...</p>
</body>
</html>
