<?php
require '/home/shakuniya/billapi.shakuniya.in/vendor/autoload.php';


use Jose\Component\Core\AlgorithmManager;
use Jose\Component\Core\JWK;
use Jose\Component\Core\Util\StringUtil;
use Jose\Component\Encryption\Algorithm\ContentEncryption\A256GCM;
use Jose\Component\Encryption\Algorithm\KeyEncryption\DirectEncryption;
use Jose\Component\Encryption\Compression\CompressionMethodManager;
use Jose\Component\Encryption\Compression\Deflate;
use Jose\Component\Encryption\JWEBuilder;
use Jose\Component\Encryption\Serializer\CompactSerializer as JWECompactSerializer;
use Jose\Component\Signature\Algorithm\HS256;
use Jose\Component\Signature\JWSBuilder;
use Jose\Component\Signature\Serializer\CompactSerializer as JWSCompactSerializer;

// Setup keys and identifiers
$clientId = 'YOUR_CLIENT_ID';
$keyId = 'YOUR_KEY_ID';
$sharedKey = '0123456789abcdef0123456789abcdef'; // 32-byte base64url or raw

// Step 1: Prepare the JSON Payload
$payload = json_encode([
    "ru" => "https://www.merchant.com/",
    "additional_info" => [
        "additional_info1" => "Details1",
        "additional_info2" => "Details2",
        "additional_info7" => "mgl"
    ],
    "itemcode" => "DIRECT",
    "device" => [
        "init_channel" => "internet",
        "ip" => "<customer’s ip>",
        "user_agent" => "Mozilla/5.0(WindowsNT10.0;WOW64;)Gecko/20100101Firefox/51.0",
        "accept_header" => "text/html"
    ]
]);

// Step 2: Create JWE (Encrypted JSON using AES-GCM)
$encryptionKey = new JWK([
    'kty' => 'oct',
    'k' => base64_encode($sharedKey), // base64-encoded key
    'kid' => $keyId,
]);

$jweBuilder = new JWEBuilder(
    new AlgorithmManager([new DirectEncryption()]),
    new AlgorithmManager([new A256GCM()]),
    new CompressionMethodManager([new Deflate()])
);

$jwe = $jweBuilder
    ->create()
    ->withPayload($payload)
    ->withSharedProtectedHeader([
        'alg' => 'dir',
        'enc' => 'A256GCM',
        'zip' => 'DEF',
        'kid' => $keyId,
        'clientid' => $clientId
    ])
    ->addRecipient($encryptionKey)
    ->build();

$jweSerializer = new JWECompactSerializer();
$encryptedPayload = $jweSerializer->serialize($jwe); // This is the encrypted JWT string

// Step 3: Sign the Encrypted Payload using HS256 (JWS)
$jwsBuilder = new JWSBuilder(
    new AlgorithmManager([new HS256()])
);

$signingKey = new JWK([
    'kty' => 'oct',
    'k' => base64_encode($sharedKey),
    'kid' => $keyId,
]);

$jws = $jwsBuilder
    ->create()
    ->withPayload($encryptedPayload)
    ->withSharedProtectedHeader([
        'alg' => 'HS256',
        'kid' => $keyId,
        'clientid' => $clientId
    ])
    ->addSignature($signingKey)
    ->build();

$jwsSerializer = new JWSCompactSerializer();
$signedEncryptedToken = $jwsSerializer->serialize($jws);

// Output: Final request to send to BillDesk
echo $signedEncryptedToken;