<?php
/**
 * BillDesk Transaction Status Check API
 * Manually checks the status of an order with BillDesk
 * Returns JSON response
 */

// Handle CORS
if (isset($_SERVER['HTTP_ORIGIN'])) {
    header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
    header('Access-Control-Allow-Credentials: true');
    header('Access-Control-Max-Age: 86400');
}

if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS");         
    if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
        header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");
    exit(0);
}

header('Content-Type: application/json');

// Suppress warnings
error_reporting(E_ALL & ~E_WARNING & ~E_NOTICE);
ini_set('display_errors', 0);

// Database Connection
$conn = null;
if (file_exists(__DIR__ . '../db.php')) {
    ob_start();
    include __DIR__ . '../db.php';
    ob_end_clean();
}

if (!$conn || !($conn instanceof mysqli)) {
    $db_host = '127.0.0.1';
    $db_port = 3306;
    $db_user = 'vyaparbot_db';
    $db_password = 't(lRbhlAT%OvKJ7s';
    $db_name = 'vyaparbot_@server';
    $conn = new mysqli($db_host, $db_user, $db_password, $db_name, $db_port);
}

if ($conn->connect_error) {
    echo json_encode(['status' => 'error', 'message' => "Database connection failed"]);
    exit;
}
$conn->set_charset("utf8mb4");

// Input
$orderId = $_GET['orderid'] ?? ($_POST['orderid'] ?? null);
$env = $_GET['env'] ?? ($_POST['env'] ?? 'prod'); // Default to prod

if (!$orderId) {
    echo json_encode(['status' => 'error', 'message' => 'Missing orderid']);
    exit;
}

// Config
$useUAT = (strtolower($env) === 'uat');

if ($useUAT) {
    define('GET_ORDER_URL', 'https://uat1.billdesk.com/u2/payments/ve1_2/transactions/get');
    $merchantId = 'BDUAT2K526';
    $clientId   = 'bduat2k526';
    $keyId      = 'apLkPDnO9NYf';
    $sharedKey  = 'xzYsZwfLeMDYzIweWT8i90QIWymCBXSn';
    $signingKey = 'RlKxmMPu6RB1BGaLKGxnnPXon8ynoSKh';
} else {
    define('GET_ORDER_URL', 'https://api.billdesk.com/payments/ve1_2/transactions/get');
    $merchantId = 'SHAKUNIYA';
    $clientId   = 'shakuniyasj';
    $keyId      = 'l6SVGjSf5Gun';
    $sharedKey  = '17mAMIqwOBvS9YIQEzeP7VStbgvXUuWK';
    $signingKey = 'z1XIAONLs2YecHz1CYiVlysiJzVzT6h8';
}

// Crypto Functions (Same as create_order.php)
function base64url_encode(string $data): string {
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}

function base64url_decode(string $data): string {
    $padded = $data . str_repeat('=', (4 - strlen($data) % 4) % 4);
    return base64_decode(strtr($padded, '-_', '+/'));
}

function createJWE(string $payload, string $key, string $keyId, string $clientId): string {
    $header = ['alg' => 'dir', 'enc' => 'A256GCM', 'kid' => $keyId, 'clientid' => $clientId];
    $protectedHeader = base64url_encode(json_encode($header));
    $iv = openssl_random_pseudo_bytes(12);
    $tag = '';
    $ciphertext = openssl_encrypt($payload, 'aes-256-gcm', $key, OPENSSL_RAW_DATA, $iv, $tag, $protectedHeader);
    return implode('.', [$protectedHeader, '', base64url_encode($iv), base64url_encode($ciphertext), base64url_encode($tag)]);
}

function createJWS(string $payload, string $key, string $keyId, string $clientId): string {
    $header = ['alg' => 'HS256', 'kid' => $keyId, 'clientid' => $clientId];
    $signingInput = base64url_encode(json_encode($header)) . '.' . base64url_encode($payload);
    $signature = hash_hmac('sha256', $signingInput, $key, true);
    return $signingInput . '.' . base64url_encode($signature);
}

function verifyJWS(string $jws, string $key): string {
    $parts = explode('.', $jws);
    if (count($parts) !== 3) throw new Exception('Invalid JWS format');
    $signingInput = $parts[0] . '.' . $parts[1];
    $signature = base64url_decode($parts[2]);
    if (!hash_equals(hash_hmac('sha256', $signingInput, $key, true), $signature)) throw new Exception('Invalid JWS signature');
    return base64url_decode($parts[1]);
}

function decryptJWE(string $jwe, string $key): string {
    $parts = explode('.', $jwe);
    if (count($parts) !== 5) throw new Exception('Invalid JWE format');
    $iv = base64url_decode($parts[2]);
    $ciphertext = base64url_decode($parts[3]);
    $tag = base64url_decode($parts[4]);
    $aad = $parts[0];
    $plaintext = openssl_decrypt($ciphertext, 'aes-256-gcm', $key, OPENSSL_RAW_DATA, $iv, $tag, $aad);
    if ($plaintext === false) throw new Exception('JWE decryption failed');
    return $plaintext;
}

try {
    // Prepare Payload
    $payload = json_encode([
        'mercid' => $merchantId,
        'orderid' => $orderId
    ]);

    // Encrypt and Sign
    $jweToken = createJWE($payload, $sharedKey, $keyId, $clientId);
    $signedToken = createJWS($jweToken, $signingKey, $keyId, $clientId);

    // Send Request
    $ch = curl_init(GET_ORDER_URL);
    curl_setopt_array($ch, [
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => $signedToken,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/jose',
            'Accept: application/jose',
            "BD-Traceid: " . bin2hex(random_bytes(16)),
            "BD-Timestamp: " . time()
        ]
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if (empty($response)) {
        throw new Exception("Empty response from BillDesk");
    }

    // Decrypt Response
    $jwePayload = verifyJWS($response, $signingKey);
    $decryptedPayload = decryptJWE($jwePayload, $sharedKey);
    $data = json_decode($decryptedPayload, true);

    if (!$data) {
        throw new Exception("Invalid JSON in response");
    }

    // Update Database
    $authStatus = $data['auth_status'] ?? null;
    $bdTransactionId = $data['transactionid'] ?? null;
    $amount = $data['amount'] ?? 0;
    
    $status = 'failed';
    if ($authStatus === '0300') $status = 'success';
    elseif ($authStatus === '0002') $status = 'pending';

    // Update orders table (New Schema)
    $stmt = $conn->prepare("UPDATE orders SET status = ?, bd_transaction_id = ?, gateway_payload = ?, updated_at = NOW() WHERE transaction_id = ?");
    if ($stmt) {
        $payloadJson = json_encode($data);
        $stmt->bind_param('ssss', $status, $bdTransactionId, $payloadJson, $orderId);
        $stmt->execute();
        $stmt->close();
    }
    echo json_encode([
        'status' => 'success',
        'data' => $data
    ]);

} catch (Exception $e) {
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
}
